%--------------------------------------------------------------------------
%   Universit catholique de Louvain
%   CEREM : Centre for research in energy and mechatronics
%   http://www.robotran.be  
%
%   Project : delta_full
%   Authors : P. Fisette and J.F. Collard
%   Year : 2012
%--------------------------------------------------------------------------

%% 1. Initialization and Project Loading [mbs_load]
%--------------------------------------------------------------------------
clc; close all; clear all;
global MBS_user;

% Project loading

[mbs_data] = mbs_load('delta_fisette_matlab','default');

% User_constraints
mbs_data.Nuserc = 3;


%% 2. Coordinate partitioning [mbs_exe_part]             % For constrained MBS only
%--------------------------------------------------------------------------
MBS_user.process = 'part';

mbs_data = mbs_set_qu(mbs_data,[1 2 3]);  % ind. coordinates

opt.part = {'rowperm','yes','threshold',1e-9,'verbose','yes'};
[mbs_part,mbs_data] = mbs_exe_part(mbs_data,opt.part);

mbs_data.q(4:end) = mod(mbs_data.q(4:end),2*pi); % suppression of 2*k*pi

% Coordinate partitioning results
disp('Coordinate partitioning results');
disp(['Sorted independent variables = ', mat2str(mbs_part.ind_u)]);
disp(['Permutated dependent variables = ', mat2str(mbs_part.ind_v)]);
disp(['Permutated independent constraints = ', mat2str(mbs_part.hu)]);
disp(['Redundant constraints = ', mat2str(mbs_part.hv)]);
disp(' ');

mbs_data_closed = mbs_data;

%% 3. Inverse kinematics [mbs_exe_solvekin]
%--------------------------------------------------------------------------
MBS_user.process = 'solvekin';

mbs_data = mbs_set_qdriven(mbs_data,[1 2 3]);  % Set the platform variables as driven

opt.solvekin = {'motion','trajectory','time',0:0.01:5,'verbose','yes'};

[mbs_solvekin,mbs_data] = mbs_exe_solvekin(mbs_data,opt.solvekin);

% Graphical Results
figure(2);
subplot(2,1,1)
plot3(mbs_solvekin.q(:,1),mbs_solvekin.q(:,2),mbs_solvekin.q(:,3));
grid
xlabel('x [m]');
ylabel('y [m]');
zlabel('z [m]');
title('Inverse kinematics: platform trajectory');
subplot(2,1,2);
plot(mbs_solvekin.tsim,mbs_solvekin.q(:,mbs_data.qa));
xlabel('Time [s]')
ylabel('Position [rad]')
legend('actuator 1','actuator 2','actuator 3');
title('Inverse kinematics: actuator angles');
grid;
pause;

%% 4. Inverse dynamics [mbs_exe_invdyn] : joints 10, 15, 20 are actuated (see the Pad)
%---------------------------------------------------------------------------------
MBS_user.process = 'invdyn';
MBS_user.friction = 'yes'; % 'yes' = with joint viscous friction, 'no' = without joint friction

mbs_data = mbs_data_closed;  
mbs_data = mbs_set_qu(mbs_data,[10 15 20]); % Set the actuated variables as independent
% mbs_data = mbs_set_qa(mbs_data,[10 15 20]); % Set the actuated variables as independent
mbs_data = mbs_set_qv(mbs_data,[1 2 3]);  % Set the platform variable as dependent


opt.invdyn = {'motion','trajectory',...
    'save2file','yes','renamefile','no','verbose','yes'};

% inverse dynamics : on the basis of the trajectory stored in simkin[d][d].res

[mbs_invdyn,mbs_data] = mbs_exe_invdyn(mbs_data,opt.invdyn);                % Inverse dynamics process

% Graphical Results
figure(3)
plot(mbs_invdyn.tsim,mbs_invdyn.Qa(:,mbs_data.qa));
grid;
title('Inverse dynamics: actuator torques'); 
xlabel('Time [s]');
ylabel('Torque [Nm]');
legend(['Actuated joint ',num2str(mbs_data.qa(1))],['Actuated joint ',num2str(mbs_data.qa(2))],['Actuated joint ',num2str(mbs_data.qa(3))]);

%% . Closing operations (optional)
%--------------------------------------------------------------------------
mbs_rm_allprjpath;                                                          % Cleaning of the Matlab project paths
mbs_del_glob('MBS_user','MBS_info','MBS_data');                             % Cleaning of the global MBS variables
% clc;                                                                        % Cleaning of the Matlab command window
